#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"

#include "BOLTFrm.h"
#include "wx/statline.h"
#include <wx/fontdlg.h>
#include "wx/fontutil.h"
enum {
	ID_USER=21666,
		ID_PASS,
		ID_OK,
		ID_CANCEL,
		ID_CHANGEDB,
		ID_QUIT
};

//IMPLEMENT_DYNAMIC_CLASS(BOLTLogin,wxDialog)
BEGIN_EVENT_TABLE(BOLTLogin,wxDialog)
EVT_BUTTON(ID_OK,BOLTLogin::OnOk)
EVT_BUTTON(ID_CANCEL,BOLTLogin::OnCancel)
EVT_BUTTON(ID_CHANGEDB,BOLTLogin::OnChangeDB)
EVT_BUTTON(ID_QUIT,BOLTLogin::OnQuit)
END_EVENT_TABLE()

BOLTLogin::BOLTLogin(BOLTdb *db,wxWindow *parent):
wxDialog(parent,-1,"Login",wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxDIALOG_MODAL)
{
#define DEFSPACE 0,wxALL,5
	this->db=db;
	wxBoxSizer *tSizer=new wxBoxSizer(wxVERTICAL);
	wxGridSizer *gSizer = new wxGridSizer(2,2,5,5);
	gSizer->Add(new wxStaticText(this,-1,"Name"));
	gSizer->Add(cUser=new wxTextCtrl(this,ID_USER,""));
	gSizer->Add(new wxStaticText(this,-1,"Password"));
	gSizer->Add(cPass=new wxTextCtrl(this,ID_PASS,"",wxDefaultPosition,wxDefaultSize,wxTE_PASSWORD));
	tSizer->Add(gSizer);
	wxBoxSizer *bSizer=new wxBoxSizer(wxHORIZONTAL);
	bSizer->Add(bOk = new wxButton(this,ID_OK,"&Ok"),DEFSPACE);
	bSizer->Add(bChangeDB = new wxButton(this,ID_CHANGEDB,"&Databases"),DEFSPACE);
//	bSizer->Add(bCancel = new wxButton(this,ID_CANCEL,"Cancel"),DEFSPACE);
//	bCancel->Show(FALSE); // makes a empty space - looks neet
	bSizer->Add(bQuit = new wxButton(this,ID_QUIT,"&Quit"),DEFSPACE);
	tSizer->Add(bSizer);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(tSizer);
	tSizer->Fit(this);
	tSizer->SetSizeHints(this);
	Center();
	cUser->SetFocus();
};

BOLTLogin::~BOLTLogin()
{
};

BOLTUser *BOLTLogin::GetUser()
{
	int userID;
	BOLTUser *user=NULL;
	wxString name;
	userID=ShowModal();
	if (userID==0)
	{ return NULL; }
	if (db==NULL)
	{ return NULL; }
	name=db->GetValue("employees","name",userID);
	user = new BOLTUser(userID,name);
	user->font=db->GetValue("employees","font",userID);
	wxString tStr=db->GetValue("employees","if (classicMode=1,1,NULL)",userID);
	user->useClassicMode=(!tStr.IsEmpty());
	user->accessLevel=db->GetIValue("employees","accessLevel",userID);
	user->LoggedIn=true;
	return user;
};

void BOLTLogin::OnCancel(wxCommandEvent& evt)
{
	cUser->SetValue("");
	cPass->SetValue("");
};

void BOLTLogin::OnChangeDB(wxCommandEvent& evt)
{
	EndModal(0);
};

void BOLTLogin::OnQuit(wxCommandEvent& evt)
{
	BOLTFrame *tWindow;
	tWindow=(BOLTFrame *)(wxGetApp().GetTopWindow());
	tWindow->Close(TRUE);
	EndModal(0);
};

void BOLTLogin::OnOk(wxCommandEvent& evt)
{
	wxString sUser,sPass,sQry;
	sUser=cUser->GetValue();
	sPass=cPass->GetValue();
	sQry.Printf("SELECT id FROM employees WHERE name='%s' AND password='%s'",sUser.c_str(),sPass.c_str());
	
	QRY_ID qry;
	void *row;

	qry=db->Query((char *)sQry.c_str(),sQry.Length());
	if (qry!=NULL)
	{
		if (row=db->FetchRow(qry))
		{
			RECORD_ID rVal;
			rVal=atoi(db->FetchQueryResult(qry,row,0));
			db->FreeQuery(qry);
			EndModal(rVal);
		}
		else
		{
		 db->FreeQuery(qry);
		 wxBell();
		}
	} else { wxBell(); }
};

enum {
	ID_UM_UPDATE=7899,
		ID_UM_NEW,
		ID_UM_DELETE,
		ID_UM_DONE,
		ID_UM_USERS,
		ID_UM_NAME,
		ID_UM_FULLNAME,
		ID_UM_INIT,
		ID_UM_FONT,
		ID_UM_PASS,
		ID_UM_CLASSIC,
		ID_UM_ACCESSLEVEL
};

//IMPLEMENT_DYNAMIC_CLASS(BOLTUserManager,wxDialog)
BEGIN_EVENT_TABLE(BOLTUserManager,wxDialog)
EVT_BUTTON(ID_UM_NEW,BOLTUserManager::OnNew)
EVT_BUTTON(ID_UM_UPDATE,BOLTUserManager::OnUpdate)
EVT_BUTTON(ID_UM_DELETE,BOLTUserManager::OnDelete)
EVT_BUTTON(ID_UM_DONE,BOLTUserManager::OnDone)
EVT_BUTTON(ID_UM_FONT,BOLTUserManager::OnFont)
EVT_TEXT(ID_UM_NAME,BOLTUserManager::OnText)
EVT_TEXT(ID_UM_FULLNAME,BOLTUserManager::OnText)
EVT_TEXT(ID_UM_INIT,BOLTUserManager::OnText)
EVT_TEXT(ID_UM_PASS,BOLTUserManager::OnText)
EVT_LISTBOX(ID_UM_USERS,BOLTUserManager::OnChoose)
EVT_CHECKBOX(ID_UM_CLASSIC,BOLTUserManager::OnText)
EVT_CHOICE(ID_UM_ACCESSLEVEL,BOLTUserManager::OnAccess)
//EVT_LISTBOX_DCLICK(ID_UM_USERS,BOLTUserManager::OnChoose)
END_EVENT_TABLE()

BOLTUserManager::BOLTUserManager(wxWindow *parent,BOLTdb* db):
wxDialog(parent,-1,"User Manager",wxDefaultPosition)
{
	//TODO - auto-register controls
	this->db=db;
	SetFont(parent->GetFont());
	wxBoxSizer  *topSizer = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer *colSizer,*hSizer;

	colSizer=new wxBoxSizer(wxVERTICAL);
	colSizer->Add(new wxStaticText(this,-1,"Users"),0,wxALIGN_CENTER|wxALL,5);
	colSizer->Add(this->lUsers=new wxListBox(this,ID_UM_USERS),1,wxEXPAND|wxALL,5);
	topSizer->Add(colSizer,1,wxEXPAND|wxALL,5);
	topSizer->Add(new wxStaticLine(this,-1,wxDefaultPosition,wxDefaultSize,wxLI_VERTICAL),0,wxEXPAND);

	FillUsers();
	colSizer=new wxBoxSizer(wxVERTICAL);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Full Name"),1,wxEXPAND|wxALL,5);
	hSizer->Add(tName=new wxTextCtrl(this,ID_UM_FULLNAME),1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Initials"),1,wxEXPAND|wxALL,5);
	hSizer->Add(tInit=new wxTextCtrl(this,ID_UM_INIT),1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	//username
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Login Name"),1,wxEXPAND|wxALL,5);
	hSizer->Add(tUser=new wxTextCtrl(this,ID_UM_NAME),1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	//password
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Password"),1,wxEXPAND|wxALL,5);
	hSizer->Add(tPass=new wxTextCtrl(this,ID_UM_PASS,"",wxDefaultPosition,wxDefaultSize,wxTE_PASSWORD),1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Font"),1,wxEXPAND|wxALL,5);
	hSizer->Add(new wxButton(this,ID_UM_FONT,"Change",wxDefaultPosition,wxDefaultSize,wxTE_PASSWORD),1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Access Level"),1,wxEXPAND|wxALL,5);
	cAccess=new wxChoice(this,ID_UM_ACCESSLEVEL);
	cAccess->Append("Disabled");
	cAccess->Append("Guest");
	cAccess->Append("Cashier");
	cAccess->Append("Supervisor");
	cAccess->Append("Manager");
	cAccess->Append("Owner");
	cAccess->Append("Technician");
	hSizer->Add(cAccess,1,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
	//TODO access level
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(cbClassicMode=new wxCheckBox(this,ID_UM_CLASSIC,"Classic Mode"),2,wxEXPAND|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);	
	//TODO color settings

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->bUpdate=new wxButton(this,ID_UM_UPDATE,"&Update"),1,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(this->bNew=new wxButton(this,ID_UM_NEW,"&New"),1,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(this->bDelete=new wxButton(this,ID_UM_DELETE,"De&lete"),1,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(this->bDone=new wxButton(this,ID_UM_DONE,"&Done"),1,wxALIGN_CENTER|wxALL,5);
	colSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	topSizer->Add(colSizer,0,wxEXPAND|wxALL,5);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );
	bUpdate->Enable(FALSE);
	bDelete->Enable(FALSE);
	Centre( wxBOTH );
	ShowModal();

}

void BOLTUserManager::OnChoose(wxCommandEvent &event)
{
	if (bUpdate->IsEnabled())
	{
		if (wxMessageBox("Would you like to save you changes to this user ?","Save",wxYES_NO,this)==wxYES)
		{
			this->OnUpdate(wxCommandEvent(0,0));
		}
	}
	tEmployeeId=aId[event.GetSelection()];

	bUpdate->Enable(tEmployeeId!=0);
	bDelete->Enable(tEmployeeId!=0);
	tUser->SetValue(db->GetValue("employees","name",tEmployeeId));
	tName->SetValue(db->GetValue("employees","fullname",tEmployeeId));
	tInit->SetValue(db->GetValue("employees","initials",tEmployeeId));
	tPass->SetValue(db->GetValue("employees","password",tEmployeeId));
	cAccess->SetSelection(db->GetIValue("employees","accessLevel",tEmployeeId));
	wxString tStr=db->GetValue("employees","if(classicMode=1,1,NULL)",tEmployeeId);
	cbClassicMode->SetValue(!tStr.IsEmpty());
	this->sFont=db->GetValue("employees","font",tEmployeeId);
	wxFont tFont;
	tFont=*wxNORMAL_FONT;
	wxNativeFontInfo tfInfo;
	tfInfo.FromString(sFont);
	tFont.SetNativeFontInfo(tfInfo);
	this->FindWindow(ID_UM_FONT)->SetFont(tFont);

	bUpdate->Enable(FALSE);
	bNew->Enable(FALSE);
}

void BOLTUserManager::OnDone(wxCommandEvent &event)
{
	EndModal(0);
}

void BOLTUserManager::OnNew(wxCommandEvent &event)
{

	int selected;
	wxString sUser,sPass,sInit,sName,tsFont,tsClassic;
	sUser.Printf("'%s'",tUser->GetValue().c_str());
	sPass.Printf("'%s'",tPass->GetValue().c_str());
	sInit.Printf("'%s'",tInit->GetValue().c_str());
	sName.Printf("'%s'",tName->GetValue().c_str());
	tsFont.Printf("'%s'",sFont.c_str());
	tsClassic.Printf("%u",cbClassicMode->IsChecked()?1:0);
	selected=lUsers->GetSelection();
	if (selected>=0)
	{ lUsers->SetSelection(selected,FALSE); }
	bNew->Enable(FALSE);
	tEmployeeId=db->NewRecord("employees");
	db->SetValue("employees","fullname",tEmployeeId,sName.c_str());
	db->SetValue("employees","name",tEmployeeId,sUser.c_str());
	db->SetValue("employees","initials",tEmployeeId,sInit.c_str());
	db->SetValue("employees","password",tEmployeeId,sPass.c_str());
	db->SetValue("employees","font",tEmployeeId,tsFont);
	db->SetValue("employees","classicMode",tEmployeeId,tsClassic);
	bUpdate->Enable(FALSE);
	bDelete->Enable(TRUE);
	lUsers->Append(tUser->GetValue());
	aId.Add(tEmployeeId);
	lUsers->SetSelection(lUsers->Number()-1);
}

void BOLTUserManager::OnUpdate(wxCommandEvent &event)
{
	wxString sUser,sPass,sInit,sName,tsFont,tsClassic;
	sName.Printf("'%s'",tName->GetValue().c_str());
	sUser.Printf("'%s'",tUser->GetValue().c_str());
	sInit.Printf("'%s'",tInit->GetValue().c_str());
	sPass.Printf("'%s'",tPass->GetValue().c_str());
	tsFont.Printf("'%s'",sFont.c_str());
	tsClassic.Printf("%u",cbClassicMode->IsChecked()?1:0);
	db->SetValue("employees","fullname",tEmployeeId,sName.c_str());
	db->SetValue("employees","name",tEmployeeId,sUser.c_str());
	db->SetValue("employees","initials",tEmployeeId,sInit.c_str());
	db->SetValue("employees","password",tEmployeeId,sPass.c_str());
	db->SetValue("employees","font",tEmployeeId,tsFont);
	db->SetValue("employees","classicMode",tEmployeeId,tsClassic);
	db->SetValue("employees","accessLevel",tEmployeeId,(RECORD_ID)cAccess->GetSelection());
	bNew->Enable(FALSE);
	bUpdate->Enable(FALSE);
	lUsers->SetString(lUsers->GetSelection(),tUser->GetValue());
}

void BOLTUserManager::UpdateUserList()
{

}

void BOLTUserManager::OnText(wxCommandEvent &event)
{
	bNew->Enable(TRUE);
	bUpdate->Enable(TRUE);
}

void BOLTUserManager::FillUsers()
{
	QRY_ID qry;
	void *row;

	wxString tStr;
	char *tmp;
	RECORD_ID employeeId;

	lUsers->Clear();
	aId.Empty();

	tStr.Printf("select id,name from employees");
	qry=db->Query((char *)tStr.c_str(),tStr.Length());
	if (qry==NULL)
	{
		if (db->IsError()) { LOG_ERROR(db->GetError()); }
		return; 
	}
//	int i=0;
	while (row=db->FetchRow(qry))
	{
		if (tmp=db->FetchQueryResult(qry,row,0))
			{ employeeId=atoi(tmp); } 
		else 
			{ employeeId=0; if (db->IsError()) { LOG_ERROR(db->GetError()); } };
		tStr=db->FetchQueryResult(qry,row,1);
		if (employeeId==user->id)
		{
			tStr.Printf("%s (current user)",tStr.c_str());
		}
		lUsers->Append(tStr);
		aId.Add(employeeId);
	}
	db->FreeQuery(qry);
}

void BOLTUserManager::OnDelete(wxCommandEvent &event)
{
	wxString tStr;
	if (tEmployeeId==user->id)
	{
		wxMessageBox("You are currently logged in as that user.","Can not delete",wxOK|wxICON_HAND,this);
		return;
	}
	if (wxMessageBox("Are you sure you want to delete this employee ?","Confirm Delete",wxYES_NO,this)==wxYES)
	{
	lUsers->SetSelection(lUsers->GetSelection(),FALSE);
	tStr.Printf("delete from employees where id=%u",tEmployeeId);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillUsers();
	tName->SetValue("");
	tUser->SetValue("");
	tInit->SetValue("");
	tPass->SetValue("");
	bDelete->Enable(FALSE);
	bUpdate->Enable(FALSE);
	bNew->Enable(FALSE);
	}
}

void BOLTUserManager::OnFont(wxCommandEvent &event)
{
	wxFont myFont;
	wxNativeFontInfo tfInfo;
	tfInfo.FromString(sFont);
	myFont.SetNativeFontInfo(tfInfo);
	tfInfo.FromString(
		db->GetValue("employees","font",tEmployeeId)
		);
	myFont=wxGetFontFromUser(this,myFont);
	if (myFont.Ok())
	{
	tfInfo=*(myFont.GetNativeFontInfo());
	this->sFont=tfInfo.ToString();
	this->FindWindow(ID_UM_FONT)->SetFont(myFont);
	bUpdate->Enable(TRUE);
	}
}

void BOLTUserManager::OnAccess(wxCommandEvent &evt)
{
	bUpdate->Enable(TRUE);
}
